/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.IRFactory;
import com.google.javascript.jscomp.parsing.parser.Parser;
import com.google.javascript.jscomp.parsing.parser.SourceFile;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.util.ErrorReporter;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;

public final class ParserRunner {
    private static final String CONFIG_RESOURCE = "com.google.javascript.jscomp.parsing.ParserConfig";
    private static Set<String> annotationNames = null;
    private static Set<String> suppressionNames = null;
    private static Set<String> reservedVars = null;

    private ParserRunner() {
    }

    public static Config createConfig(boolean isIdeMode, Config.LanguageMode languageMode, boolean acceptConstKeyword, Set<String> extraAnnotationNames) {
        return ParserRunner.createConfig(isIdeMode, isIdeMode, languageMode, acceptConstKeyword, extraAnnotationNames);
    }

    public static Config createConfig(boolean isIdeMode, boolean parseJsDocDocumentation, Config.LanguageMode languageMode, boolean acceptConstKeyword, Set<String> extraAnnotationNames) {
        Set<String> effectiveAnnotationNames;
        ParserRunner.initResourceConfig();
        if (extraAnnotationNames == null) {
            effectiveAnnotationNames = annotationNames;
        } else {
            effectiveAnnotationNames = new HashSet<String>(annotationNames);
            effectiveAnnotationNames.addAll(extraAnnotationNames);
        }
        return new Config(effectiveAnnotationNames, suppressionNames, isIdeMode, parseJsDocDocumentation, languageMode, acceptConstKeyword);
    }

    public static Set<String> getReservedVars() {
        ParserRunner.initResourceConfig();
        return reservedVars;
    }

    private static synchronized void initResourceConfig() {
        if (annotationNames != null) {
            return;
        }
        ResourceBundle config = ResourceBundle.getBundle(CONFIG_RESOURCE);
        annotationNames = ParserRunner.extractList(config.getString("jsdoc.annotations"));
        suppressionNames = ParserRunner.extractList(config.getString("jsdoc.suppressions"));
        reservedVars = ParserRunner.extractList(config.getString("compiler.reserved.vars"));
    }

    private static Set<String> extractList(String configProp) {
        return ImmutableSet.copyOf((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)configProp));
    }

    public static ParseResult parse(StaticSourceFile sourceFile, String sourceString, Config config, com.google.javascript.rhino.ErrorReporter errorReporter) {
        SourceFile file = new SourceFile(sourceFile.getName(), sourceString);
        Es6ErrorReporter es6ErrorReporter = new Es6ErrorReporter(errorReporter, file, config);
        Parser.Config es6config = new Parser.Config(ParserRunner.mode(config.languageMode));
        Parser p = new Parser(es6config, es6ErrorReporter, file);
        ProgramTree tree = p.parseProgram();
        Node root = null;
        Object comments = ImmutableList.of();
        if (tree != null && (!es6ErrorReporter.hadError() || config.isIdeMode)) {
            root = IRFactory.transformTree(tree, sourceFile, sourceString, config, errorReporter);
            root.setIsSyntheticBlock(true);
            if (config.isIdeMode) {
                comments = p.getComments();
            }
        }
        return new ParseResult(root, (List<Comment>)comments);
    }

    private static Parser.Config.Mode mode(Config.LanguageMode mode) {
        switch (mode) {
            case ECMASCRIPT3: {
                return Parser.Config.Mode.ES3;
            }
            case ECMASCRIPT5: {
                return Parser.Config.Mode.ES5;
            }
            case ECMASCRIPT5_STRICT: {
                return Parser.Config.Mode.ES5_STRICT;
            }
            case ECMASCRIPT6: {
                return Parser.Config.Mode.ES6;
            }
            case ECMASCRIPT6_STRICT: {
                return Parser.Config.Mode.ES6_STRICT;
            }
            case ECMASCRIPT6_TYPED: {
                return Parser.Config.Mode.ES6_TYPED;
            }
        }
        throw new IllegalStateException("unexpected language mode: " + (Object)((Object)mode));
    }

    public static class ParseResult {
        public final Node ast;
        public final List<Comment> comments;

        public ParseResult(Node ast, List<Comment> comments) {
            this.ast = ast;
            this.comments = comments;
        }
    }

    private static class Es6ErrorReporter
    extends ErrorReporter {
        private com.google.javascript.rhino.ErrorReporter reporter;
        private boolean errorSeen = false;
        private boolean isIdeMode;

        Es6ErrorReporter(com.google.javascript.rhino.ErrorReporter reporter, SourceFile source, Config config) {
            this.reporter = reporter;
            this.isIdeMode = config.isIdeMode;
        }

        @Override
        protected void reportError(SourcePosition location, String message) {
            if (this.isIdeMode || !this.errorSeen) {
                this.errorSeen = true;
                this.reporter.error(message, location.source.name, location.line + 1, location.column);
            }
        }

        @Override
        protected void reportWarning(SourcePosition location, String message) {
            this.reporter.warning(message, location.source.name, location.line + 1, location.column);
        }
    }
}

