/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
public class ResultSetProxyFactory
implements InvocationHandler,
LogicalObject {
    protected static ConcurrentMap<Class, Constructor> constructorMap = new ConcurrentHashMap<Class, Constructor>();
    private final ResultSet m_proxiedResultSet;
    private final Statement m_proxyStatement;
    private final JDBCUniversalPooledConnection m_jdbcPooledConnection;
    private final JDBCConnectionPool m_jdbcConnectionPool;
    private boolean m_closed = false;
    protected final long creationTS = Clock.clock();
    protected final boolean isReplayable;
    private static final Map<Class, Class[]> m_mapInterfaces = new HashMap<Class, Class[]>();

    public static Object createResultSetProxy(Object proxiedResultSet, Object proxyStatement, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        if (proxiedResultSet == null) {
            return null;
        }
        Object rsetProxy = null;
        try {
            rsetProxy = ResultSetProxyFactory.createProxyHelper(proxyStatement.getClass().getClassLoader(), proxiedResultSet, proxyStatement, jdbcConnectionPool, jdbcPooledConnection);
        }
        catch (Throwable e) {
            try {
                rsetProxy = ResultSetProxyFactory.createProxyHelper(ResultSetProxyFactory.class.getClassLoader(), proxiedResultSet, proxyStatement, jdbcConnectionPool, jdbcPooledConnection);
            }
            catch (Throwable ee) {
                throw new UniversalConnectionPoolException(ee);
            }
        }
        return rsetProxy;
    }

    private static Object createProxyHelper(ClassLoader clsLoader, Object proxiedResultSet, Object proxyStatement, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws Exception {
        Class<?> rsetClass = proxiedResultSet.getClass();
        Constructor<?> constructor = (Constructor<?>)constructorMap.get(rsetClass);
        if (constructor == null) {
            Class<?> pxyClass = Proxy.getProxyClass(clsLoader, ResultSetProxyFactory.createInterfaces(proxiedResultSet));
            constructor = pxyClass.getConstructor(InvocationHandler.class);
        }
        Object rsetProxy = constructor.newInstance(new ResultSetProxyFactory(proxiedResultSet, proxyStatement, jdbcConnectionPool, jdbcPooledConnection));
        if (null == constructorMap.putIfAbsent(rsetClass, constructor)) {
        }
        return rsetProxy;
    }

    private ResultSetProxyFactory(Object proxiedResultSet, Object proxyStatement, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        int errCode;
        if (null == jdbcPooledConnection) {
            errCode = 150;
        } else if (null == jdbcConnectionPool) {
            errCode = 54;
        } else if (!(proxiedResultSet instanceof ResultSet)) {
            errCode = 266;
        } else if (!(proxyStatement instanceof Statement)) {
            errCode = 265;
        } else {
            this.m_proxiedResultSet = (ResultSet)proxiedResultSet;
            this.m_proxyStatement = (Statement)proxyStatement;
            this.m_jdbcConnectionPool = jdbcConnectionPool;
            this.m_jdbcPooledConnection = jdbcPooledConnection;
            Connection m_proxyConn = null;
            try {
                m_proxyConn = this.m_proxyStatement.getConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.isReplayable = m_proxyConn instanceof ReplayableConnection;
            return;
        }
        throw UCPErrorHandler.newUniversalConnectionPoolException(errCode);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int arglen;
        this.m_jdbcPooledConnection.heartbeat();
        int n = arglen = null == args ? 0 : args.length;
        if (1 == arglen && "equals".equals(method.getName())) {
            return new Boolean(proxy == args[0]);
        }
        if (0 == arglen) {
            if ("hashCode".equals(method.getName())) {
                return new Integer(System.identityHashCode(proxy));
            }
            if ("toString".equals(method.getName())) {
                return proxy.getClass().getName() + "@" + Integer.toHexString(proxy.hashCode());
            }
        }
        String methodName = method.getName();
        if (!this.m_closed && "getStatement".equals(methodName)) {
            return this.m_proxyStatement;
        }
        UniversalPooledConnectionStatus status = this.m_jdbcPooledConnection.getStatus();
        Object result = null;
        try {
            if (Clock.isBefore(this.creationTS, this.m_jdbcPooledConnection.getAvailableStartTime()) || Clock.isBefore(this.creationTS, this.m_jdbcPooledConnection.getBorrowedStartTime())) {
                this.m_closed = true;
                if (!this.m_proxyStatement.isClosed()) {
                    this.m_proxyStatement.getConnection().close();
                }
            }
            if ("close".equals(methodName)) {
                if (this.m_closed) {
                    return null;
                }
                this.m_closed = true;
            } else if ("isClosed".equals(methodName)) {
                if (this.m_closed || this.m_proxyStatement.isClosed()) {
                    return true;
                }
            } else {
                if ("isLogicallyClosed".equals(methodName)) {
                    return method.invoke((Object)this, args);
                }
                if (this.m_closed && !"_getDelegate_".equals(methodName)) {
                    throw UCPErrorHandler.newSQLException(43);
                }
                if (((LogicalObject)((Object)this.m_proxyStatement)).isLogicallyClosed()) {
                    throw UCPErrorHandler.newSQLException(44);
                }
                if (((LogicalObject)((Object)this.m_proxyStatement.getConnection())).isLogicallyClosed()) {
                    throw UCPErrorHandler.newSQLException(31);
                }
            }
            result = method.invoke((Object)this.m_proxiedResultSet, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof SQLRecoverableException) {
                this.m_jdbcPooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.m_jdbcConnectionPool.returnConnection(this.m_jdbcPooledConnection);
            }
            throw t;
        }
        catch (Throwable e) {
            throw e;
        }
        this.m_jdbcPooledConnection.heartbeat();
        return result;
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.m_closed;
    }

    private static Class[] createInterfaces(Object object) {
        Class<?> objectClass = object.getClass();
        Class[] interfaces = m_mapInterfaces.get(objectClass);
        if (null != interfaces) {
            return interfaces;
        }
        HashSet<Class> interfacesSet = new HashSet<Class>();
        ResultSetProxyFactory.addInterfaces(interfacesSet, objectClass);
        interfacesSet.add(LogicalObject.class);
        interfaces = interfacesSet.toArray(new Class[0]);
        m_mapInterfaces.put(objectClass, interfaces);
        return interfaces;
    }

    private static void addInterfaces(HashSet<Class> interfaces, Class type) {
        if (type != null) {
            for (Class<?> proxyInterface : type.getInterfaces()) {
                if (!Modifier.isPublic(proxyInterface.getModifiers())) continue;
                interfaces.add(proxyInterface);
            }
            ResultSetProxyFactory.addInterfaces(interfaces, type.getSuperclass());
        }
    }
}

