/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobInputStream
extends OracleBufferedStream {
    protected long lobOffset;
    protected CLOB clob;
    protected long markedByte;
    protected boolean endOfStream;
    protected char[] charBuf;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Aug_26_08:17:01_PDT_2011";
    public static final boolean TRACE = false;

    public OracleClobInputStream(CLOB cLOB) throws SQLException {
        this(cLOB, ((PhysicalConnection)cLOB.getJavaSqlConnection()).getDefaultStreamChunkSize(), 1L);
    }

    public OracleClobInputStream(CLOB cLOB, int n2) throws SQLException {
        this(cLOB, n2, 1L);
    }

    public OracleClobInputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        super(n2);
        if (cLOB == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException();
        }
        this.lobOffset = l2;
        this.clob = cLOB;
        this.markedByte = -1L;
        this.endOfStream = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needBytes(int n2) throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    if (n2 > this.currentBufferSize) {
                        PhysicalConnection physicalConnection;
                        this.currentBufferSize = Math.max(n2, this.initialBufferSize);
                        PhysicalConnection physicalConnection2 = physicalConnection = (PhysicalConnection)this.clob.getInternalConnection();
                        synchronized (physicalConnection2) {
                            this.resizableBuffer = physicalConnection.getByteBuffer(this.currentBufferSize);
                            this.charBuf = physicalConnection.getCharBuffer(this.currentBufferSize);
                        }
                    }
                    this.count = this.clob.getChars(this.lobOffset, this.currentBufferSize, this.charBuf);
                    for (int i2 = 0; i2 < this.count; ++i2) {
                        this.resizableBuffer[i2] = (byte)this.charBuf[i2];
                    }
                    if (this.count < this.currentBufferSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lobOffset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    IOException iOException = DatabaseError.createIOException(sQLException);
                    iOException.fillInStackTrace();
                    throw iOException;
                }
            }
            return false;
        }
        return true;
    }

    protected void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = DatabaseError.createIOException(sQLException);
            iOException.fillInStackTrace();
            throw iOException;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(DatabaseError.findMessage(196, null));
        }
        this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
    }

    public void markInternal(int n2) {
    }

    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markedByte < 0L) {
            throw new IOException(DatabaseError.findMessage(195, null));
        }
        this.lobOffset = this.markedByte;
        this.pos = this.count;
        this.endOfStream = false;
    }

    public long skip(long l2) throws IOException {
        this.ensureOpen();
        long l3 = 0L;
        if ((long)(this.count - this.pos) >= l2) {
            this.pos = (int)((long)this.pos + l2);
            l3 += l2;
        } else {
            l3 += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long l4 = 0L;
                l4 = this.clob.length() - this.lobOffset + 1L;
                if (l4 >= l2 - l3) {
                    this.lobOffset += l2 - l3;
                    l3 += l2 - l3;
                } else {
                    this.lobOffset += l4;
                    l3 += l4;
                }
            }
            catch (SQLException sQLException) {
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            super.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                PhysicalConnection physicalConnection;
                PhysicalConnection physicalConnection2 = physicalConnection = (PhysicalConnection)this.clob.getInternalConnection();
                synchronized (physicalConnection2) {
                    if (this.charBuf != null) {
                        physicalConnection.cacheBuffer(this.charBuf);
                        this.charBuf = null;
                    }
                    if (this.resizableBuffer != null) {
                        physicalConnection.cacheBuffer(this.resizableBuffer);
                        this.resizableBuffer = null;
                    }
                    this.currentBufferSize = 0;
                }
            }
            catch (SQLException sQLException) {
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
            throw throwable;
        }
        try {
            PhysicalConnection physicalConnection;
            PhysicalConnection physicalConnection3 = physicalConnection = (PhysicalConnection)this.clob.getInternalConnection();
            synchronized (physicalConnection3) {
                if (this.charBuf != null) {
                    physicalConnection.cacheBuffer(this.charBuf);
                    this.charBuf = null;
                }
                if (this.resizableBuffer != null) {
                    physicalConnection.cacheBuffer(this.resizableBuffer);
                    this.resizableBuffer = null;
                }
                this.currentBufferSize = 0;
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = DatabaseError.createIOException(sQLException);
            iOException.fillInStackTrace();
            throw iOException;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.clob.getInternalConnection();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

