/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import oracle.sql.Datum;
import oracle.sql.LdxLib;
import oracle.sql.LdxLibServer;
import oracle.sql.LdxLibThin;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMPTZ;

public class DATE
extends Datum {
    static final long serialVersionUID = 5229717576495161269L;
    public static final int BDA = 1;
    public static final int BDAL = 2;
    public static final int BMO = 4;
    public static final int BMOL = 8;
    public static final int BYR = 16;
    public static final int BYRL = 32;
    public static final int BHR = 64;
    public static final int BHRL = 128;
    public static final int BMN = 256;
    public static final int BMNL = 512;
    public static final int BSC = 1024;
    public static final int BSCL = 2048;
    public static final int MSD = 4096;
    public static final int YR0 = 8192;
    public static final int BDT = 32768;
    public static final int HRZER0 = 65536;
    public static final int MIZERO = 131072;
    public static final int SEZERO = 262144;
    private static final byte LDXTCE = 0;
    private static final byte LDXTYE = 1;
    private static final byte LDXTMO = 2;
    private static final byte LDXTDA = 3;
    private static final byte LDXTHO = 4;
    private static final byte LDXTMI = 5;
    private static final byte LDXTSE = 6;
    private static LdxLib _sldxlib;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Fri_Aug_26_08:17:01_PDT_2011";
    public static final boolean TRACE = false;

    public DATE() {
        super(DATE._initDate());
    }

    public DATE(byte[] byArray) {
        super(byArray);
    }

    public DATE(java.sql.Date date) {
        super(DATE.toBytes(date));
    }

    public DATE(Time time) {
        super(DATE.toBytes(time));
    }

    public DATE(Timestamp timestamp) {
        super(DATE.toBytes(timestamp));
    }

    public DATE(java.sql.Date date, Calendar calendar) {
        super(DATE.toBytes(date, calendar));
    }

    public DATE(Time time, Calendar calendar) {
        super(DATE.toBytes(time, calendar));
    }

    public DATE(Timestamp timestamp, Calendar calendar) {
        super(DATE.toBytes(timestamp, calendar));
    }

    public DATE(String string) {
        super(DATE.toBytes(string));
    }

    public DATE(String string, boolean bl) throws ParseException {
        super(DATE.toBytes(string));
        if (!bl) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");
            simpleDateFormat.setLenient(false);
            Date date = simpleDateFormat.parse(string);
        }
    }

    public DATE(String string, Calendar calendar) {
        super(DATE.toBytes(string, calendar));
    }

    public DATE(Object object) throws SQLException {
        if (object instanceof java.sql.Date) {
            this.setShareBytes(DATE.toBytes((java.sql.Date)object));
        } else if (object instanceof Time) {
            this.setShareBytes(DATE.toBytes((Time)object));
        } else if (object instanceof Timestamp) {
            this.setShareBytes(DATE.toBytes((Timestamp)object));
        } else if (object instanceof String) {
            this.setShareBytes(DATE.toBytes((String)object));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public DATE(Object object, Calendar calendar) throws SQLException {
        if (object instanceof java.sql.Date) {
            this.setShareBytes(DATE.toBytes((java.sql.Date)object, calendar));
        } else if (object instanceof Time) {
            this.setShareBytes(DATE.toBytes((Time)object, calendar));
        } else if (object instanceof Timestamp) {
            this.setShareBytes(DATE.toBytes((Timestamp)object, calendar));
        } else if (object instanceof String) {
            this.setShareBytes(DATE.toBytes((String)object, calendar));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public static java.sql.Date toDate(byte[] byArray) {
        int n2;
        int[] nArray = new int[7];
        for (n2 = 0; n2 < 7; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        int n3 = n2 - 1900;
        if (n2 <= 0) {
            ++n3;
        }
        return new java.sql.Date(n3, nArray[2] - 1, nArray[3]);
    }

    public static Time toTime(byte[] byArray) {
        int[] nArray = new int[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        return new Time(nArray[4] - 1, nArray[5] - 1, nArray[6] - 1);
    }

    public static Timestamp toTimestamp(byte[] byArray) {
        int n2;
        int[] nArray = new int[7];
        for (n2 = 0; n2 < 7; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        int n3 = n2 - 1900;
        if (n2 <= 0) {
            ++n3;
        }
        return new Timestamp(n3, nArray[2] - 1, nArray[3], nArray[4] - 1, nArray[5] - 1, nArray[6] - 1, 0);
    }

    public static java.sql.Date toDate(byte[] byArray, Calendar calendar) {
        int n2;
        int[] nArray = new int[7];
        for (n2 = 0; n2 < 7; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        java.sql.Date date = new java.sql.Date(calendar.getTime().getTime());
        return date;
    }

    public static Time toTime(byte[] byArray, Calendar calendar) {
        int[] nArray = new int[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        Time time = new Time(calendar.getTime().getTime());
        return time;
    }

    public static Timestamp toTimestamp(byte[] byArray, Calendar calendar) {
        int n2;
        int[] nArray = new int[7];
        for (n2 = 0; n2 < 7; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        return timestamp;
    }

    public static String toString(byte[] byArray) {
        int n2;
        int[] nArray = new int[7];
        for (n2 = 0; n2 < 7; ++n2) {
            nArray[n2] = byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2];
        }
        n2 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4] - 1;
        int n6 = nArray[5] - 1;
        int n7 = nArray[6] - 1;
        int n8 = -1;
        return TIMESTAMPTZ.toString(n2, n3, n4, n5, n6, n7, -1, null);
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(java.sql.Date date) {
        if (date == null) {
            return null;
        }
        byte[] byArray = new byte[7];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n2 = calendar.get(1);
        if (calendar.get(0) == 0) {
            n2 = -n2;
        }
        if (n2 < -4712 || n2 > 9999) {
            throw new IllegalArgumentException("Invalid year value");
        }
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return byArray;
    }

    public static byte[] toBytes(Time time) {
        if (time == null) {
            return null;
        }
        byte[] byArray = new byte[7];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        byArray[0] = 119;
        byArray[1] = -86;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        return byArray;
    }

    public static byte[] toBytes(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        byte[] byArray = new byte[7];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        int n2 = calendar.get(1);
        if (calendar.get(0) == 0) {
            n2 = -n2;
        }
        if (n2 < -4712 || n2 > 9999) {
            throw new IllegalArgumentException("Invalid year value");
        }
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        return byArray;
    }

    public static byte[] toBytes(java.sql.Date date, Calendar calendar) {
        if (date == null) {
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.setTime(date);
        byte[] byArray = new byte[7];
        int n2 = calendar.get(1);
        if (calendar.get(0) == 0) {
            n2 = -n2;
        }
        if (n2 < -4712 || n2 > 9999) {
            throw new IllegalArgumentException("Invalid year value");
        }
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return byArray;
    }

    public static byte[] toBytes(Time time, Calendar calendar) {
        if (time == null) {
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.setTime(time);
        byte[] byArray = new byte[]{119, -86, 1, 1, (byte)(calendar.get(11) + 1), (byte)(calendar.get(12) + 1), (byte)(calendar.get(13) + 1)};
        return byArray;
    }

    public static byte[] toBytes(Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            return null;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.clear();
        calendar.setTime(timestamp);
        byte[] byArray = new byte[7];
        int n2 = calendar.get(1);
        if (calendar.get(0) == 0) {
            n2 = -n2;
        }
        if (n2 < -4712 || n2 > 9999) {
            throw new IllegalArgumentException("Invalid year value");
        }
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        return byArray;
    }

    public static byte[] toBytes(String string) {
        return DATE.toBytes(Timestamp.valueOf(string));
    }

    public static byte[] toBytes(String string, Calendar calendar) {
        return DATE.toBytes(Timestamp.valueOf(string), calendar);
    }

    public java.sql.Date dateValue() {
        return DATE.toDate(this.getBytes());
    }

    public Time timeValue() {
        return DATE.toTime(this.getBytes());
    }

    public Timestamp timestampValue() {
        return DATE.toTimestamp(this.getBytes());
    }

    public java.sql.Date dateValue(Calendar calendar) {
        return DATE.toDate(this.getBytes(), calendar);
    }

    public Time timeValue(Calendar calendar) {
        return DATE.toTime(this.getBytes(), calendar);
    }

    public Timestamp timestampValue(Calendar calendar) {
        return DATE.toTimestamp(this.getBytes(), calendar);
    }

    public String stringValue() {
        return DATE.toString(this.getBytes());
    }

    public String toString() {
        return this.stringValue();
    }

    public Object toJdbc() {
        return this.timestampValue();
    }

    public Object makeJdbcArray(int n2) {
        Timestamp[] timestampArray = new Timestamp[n2];
        return timestampArray;
    }

    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    public DATE addJulianDays(int n2, int n3) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxads(this.shareBytes(), n2, n3));
    }

    public DATE addMonths(int n2) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxadm(this.shareBytes(), n2));
    }

    public void diffInJulianDays(DATE dATE, int[] nArray, int[] nArray2) throws SQLException {
        DATE._getLdxLib().ldxsub(this.shareBytes(), dATE.shareBytes(), nArray, nArray2);
    }

    public NUMBER diffInMonths(DATE dATE) throws SQLException {
        return new NUMBER(DATE._getLdxLib().ldxsbm(this.shareBytes(), dATE.shareBytes()));
    }

    public static DATE getCurrentDate() throws SQLException {
        return new DATE(DATE._getLdxLib().ldxgdt());
    }

    public static int checkValidity(byte[] byArray) throws SQLException {
        return DATE._getLdxLib().ldxchk(byArray);
    }

    public static DATE fromJulianDays(int n2, int n3) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxdfd(n2, n3));
    }

    public static DATE fromText(String string, String string2, String string3) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxstd(string, string2, string3));
    }

    public DATE lastDayOfMonth() throws SQLException {
        return new DATE(DATE._getLdxLib().ldxldd(this.shareBytes()));
    }

    public static void numberToJulianDays(NUMBER nUMBER, int[] nArray, int[] nArray2) throws SQLException {
        DATE._getLdxLib().ldxftd(nUMBER.toBytes(), nArray, nArray2);
    }

    public DATE round(String string) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxrnd(this.shareBytes(), string));
    }

    public DATE setDayOfWeek(int n2) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxnxd(this.shareBytes(), n2));
    }

    public void toJulianDays(int[] nArray, int[] nArray2) throws SQLException {
        DATE._getLdxLib().ldxdtd(this.shareBytes(), nArray, nArray2);
    }

    public NUMBER toNumber() throws SQLException {
        return new NUMBER(DATE._getLdxLib().ldxdyf(this.shareBytes()));
    }

    public String toText(String string, String string2) throws SQLException {
        return DATE._getLdxLib().ldxdts(this.shareBytes(), string, string2);
    }

    public String toText(byte[] byArray, String string) throws SQLException {
        return DATE._getLdxLib().ldxdts(this.shareBytes(), byArray, string);
    }

    public static byte[] parseFormat(String string, String string2) throws SQLException {
        return DATE._getLdxLib().ldxsto(string, string2);
    }

    public DATE truncate(String string) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxtrn(this.shareBytes(), string));
    }

    public int compareTo(DATE dATE) {
        return DATE.compareBytes(this.shareBytes(), dATE.shareBytes());
    }

    private static byte[] _initDate() {
        byte[] byArray = new byte[]{119, -86, 1, 1, 1, 1, 1};
        return byArray;
    }

    private static LdxLib _getLdxLib() {
        if (_sldxlib == null) {
            try {
                _sldxlib = System.getProperty("oracle.jserver.version") != null ? new LdxLibServer() : new LdxLibThin();
            }
            catch (SecurityException securityException) {
                _sldxlib = new LdxLibThin();
            }
        }
        return _sldxlib;
    }

    private static void _printBytes(byte[] byArray) {
        System.out.println(DATE.toString(byArray));
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

