/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource.loader;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.resource.PlexusResource;
import org.codehaus.plexus.resource.loader.AbstractResourceLoader;
import org.codehaus.plexus.resource.loader.FilePlexusResource;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;

@Component(role=ResourceLoader.class, hint="file", instantiationStrategy="per-lookup")
public class FileResourceLoader
extends AbstractResourceLoader {
    public static final String ID = "file";

    public PlexusResource getResource(String name) throws ResourceNotFoundException {
        for (String path : this.paths) {
            File file = new File(path, name);
            if (!file.canRead()) continue;
            return new FilePlexusResource(file);
        }
        File file = new File(name);
        if (file.isAbsolute() && file.canRead()) {
            return new FilePlexusResource(file);
        }
        throw new ResourceNotFoundException(name);
    }

    public static File getResourceAsFile(String name, String outputPath, File outputDirectory) throws FileResourceCreationException {
        File f = new File(name);
        if (f.exists()) {
            if (outputPath == null) {
                return f;
            }
            try {
                File outputFile = outputDirectory != null ? new File(outputDirectory, outputPath) : new File(outputPath);
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                FileUtils.copyFile((File)f, (File)outputFile);
                return outputFile;
            }
            catch (IOException e) {
                throw new FileResourceCreationException("Cannot create file-based resource.", e);
            }
        }
        return null;
    }
}

